/*
 * TagEntry.h
 *
 *  Created on: 15.10.2009
 *      Author: stefan.detter
 */

#ifndef TAGENTRY_H_
#define TAGENTRY_H_

#include "data/TagData.h"
#include <QTime>
#include <QDateTime>
#include <QVector>
#include <QStringList>

#include "TreeItem.h"


#include "../../application/event/TagEvent.h"

class ReaderEntry;
class AntennaEntry;
class InfoEntry;


class TagEntry : public TreeItem
{
	Q_OBJECT

	typedef enum {
		 STATE_ACTIVE,
		 STATE_INACTIVE ,
		 STATE_OUTOFRANGE,
	} TagState;

	typedef enum
	{
		TAG_ROW_HEADER = 0,
		TAG_ROW_COMMON,
		TAG_ROW_TagId,
		TAG_ROW_TagType,
		TAG_ROW_CURRENTREAD,
		TAG_ROW_State,
		TAG_ROW_TimeStamp,
		TAG_ROW_ReadCount,
		TAG_ROW_ReadRate,
		TAG_ROW_MaxReadRate
	} TAG_INFORMATION_ROW_INDEX;

public:
    TagEntry(TreeItem* parent, ReaderEntry* reader, AntennaEntry* antenna, const QString& type, const QString& tagId, const QString& visualTagId);
	virtual ~TagEntry();

	void 			update ( const TagEvent& event );

	ReaderEntry*	reader() const;
	AntennaEntry*	antenna() const;
	uint 			antennaId() const;
	QString			tagId() const;
    QString			visualTagId() const;
	QString 		tagType() const;
	uint			readCount() const;
	QDateTime		timeStamp() const;
	QString			timeStampString() const;

public:
	void 			inventoryStarted();
	void 			inventoryStoped();
    void            inventoryPaused();
    void            inventoryContinued();

	void 			removeRSSI();
	void 			removeReadFrequency();

signals:
	void 			shouldBeRemoved(const QString& tagId);

public:
	virtual void	updateDynamicInfo();

private slots:
	void			triggerTimeOut();

    void            createAsciiInformation();

private:
    void 			handleInformation( const RSSI_Information& info );
	void 			handleInformation( const MEMORY_Information& info );
	void 			handleInformation( const TRIGGER_Information& info );
	void 			handleInformation( const FREQUENCY_Information& info );
	void 			handleInformation( const STATE_Information& info );
	void 			handleInformation( const BATTERY_Information& info );
	void 			handleInformation( const HANDLE_Information& info );
	void 			handleInformation( const PC_Information& info );
	void 			handleInformation( const MESSAGEID_Information& info );
    void 			handleInformation( const RN16_Information& info );
    void 			handleInformation( const NXP_BRANDID_Information& info );
    void 			handleInformation( const GENERIC_Information& info );

	void 			removeFrequencyEntries();

/****************************************************** Display functions */
public:
	virtual TYPE 		itemType() const;
	virtual QVariant 	data(int column, int role) const;
	virtual QVariant	information (int row, int column, int role) const;

private:
	void 				prepareInformation ( );
	void 				updateInformation ( );

private:
	QString 			stateToString(TagState state);


private:
	ReaderEntry*	m_reader;
	AntennaEntry*	m_antenna;
	TagData 		m_tag;
	bool			m_justCreated;
	uint			m_readCount;
	TagState		m_state;

	bool			m_readRunning;
    QTime			m_lastStarted;
	quint64			m_timeRunning;
	double			m_readRate;
	double 			m_maxReadRate;
	QDateTime		m_timeStamp;
	QTime			m_lastRead;

	QMap<ulong,ulong> m_frequencyCount;

	QTimer*			m_triggerTimer;
	bool			m_triggered;
	QString			m_triggerSource;

	QMap<QString, InfoEntry*>	m_tagInfos;

	QStringList		rssiChilds;
};

#endif /* TAGENTRY_H_ */
